﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using FDK;

namespace StrokeStyleT
{
	class C起動ステージ: CActivity
	{
		public C起動ステージ()
		{
			this.list子Activities.Add( this.Actフェードイン = new CMActフェードイン・透明度( 4 ) );
			this.list子Activities.Add( this.Actフェードアウト = new CMActフェードアウト・透明度( 4 ) );
		}

		protected override void Onデバイスリソースの作成()
		{
			lock( this )
			{
				Global.tデバイスをロックして処理を行う( ( hLockedDevice ) => {

					this.tx背景 = new CTexture( hLockedDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\ScreenCaution.jpg" ) );
					this.tx黒板 = new CTexture( hLockedDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\Black 64x64.png" ) );

				} );
			}
		}
		protected override void Onデバイスリソースの解放()
		{
			lock( this )
			{
				if( null != this.tx背景 )
				{
					this.tx背景.Dispose();
					this.tx背景 = null;
				}
				if( null != this.tx黒板 )
				{
					this.tx黒板.Dispose();
					this.tx黒板 = null;
				}
			}
		}
		protected override void On活性化()
		{
			lock( this )
			{
				this.eフェーズID = new CAtom<EフェーズID>( EフェーズID.フェードイン );
				this.Timer = new CTimer( CTimer.E種別.MultiMedia );
			}
		}
		protected override void On非活性化()
		{
			lock( this )
			{
				if( null != this.eフェーズID )
				{
					this.eフェーズID.Dispose();
					this.eフェーズID = null;
				}
				if( null != this.Timer )
				{
					this.Timer.Dispose();
					this.Timer = null;
				}
			}
		}
		protected override int On進行()
		{
			lock( this )
			{
				if( this.b活性化してない )
					return (int) E進行結果.完了;


				if( this.b初めての進行 )
				{
					this.Actフェードイン.t開始();
					this.Timer.tリセット();
					this.b初めての進行 = false;
				}


				this.Timer.t更新();


				switch( this.eフェーズID.Get() )
				{
					case EフェーズID.フェードイン:						// 0 ～ n間隔ms; フェードイン
						this.Actフェードイン.On進行();
						if( this.Timer.n現在時刻ms > n各フェーズにかける時間ms )
							this.eフェーズID.Set( EフェーズID.通常 );
						break;

					case EフェーズID.通常:								// n間隔ms ～ n間隔ms×2; 画面表示
						if( this.Timer.n現在時刻ms > n各フェーズにかける時間ms * 2 )
						{
							this.eフェーズID.Set( EフェーズID.フェードアウト );
							this.Actフェードアウト.t開始();
						}
						break;

					case EフェーズID.フェードアウト:					// n間隔ms×2 ～ n間隔ms×3; フェードアウト
						this.Actフェードアウト.On進行();
						if( this.Timer.n現在時刻ms > n各フェーズにかける時間ms * 3 )
							return (int) E進行結果.完了;				// 完了
						break;
				}

				#region [ ESC → 終了 ]
				//-----------------
				if( Global.Input.Keyboard.bキーが押された( Key.Escape ) )
					Global.App.bアプリケーションを終了する.Set( true );
				//-----------------
				#endregion

				return (int) E進行結果.継続;
			}
		}
		protected override void On描画( IntPtr hDevice )
		{
			lock( this )
			{
				if( this.b活性化してない )
					return;

				this.tx背景.t2D描画( hDevice, 0, 0 );

				switch( this.eフェーズID.Get() )
				{
					case EフェーズID.フェードイン:
						this.Actフェードイン.On描画( hDevice, this.tx黒板 );
						break;

					case EフェーズID.通常:
						break;

					case EフェーズID.フェードアウト:
						this.Actフェードアウト.On描画( hDevice, this.tx黒板 );
						break;
				}
			}
		}

		private enum EフェーズID
		{
			フェードイン,
			通常,
			フェードアウト
		};
		private CAtom<EフェーズID> eフェーズID;
		private const long n各フェーズにかける時間ms = 2000;
		
		private CMActフェードイン・透明度 Actフェードイン;
		private CMActフェードアウト・透明度 Actフェードアウト;
		private CTexture tx背景 = null;
		private CTexture tx黒板 = null;
		private CTimer Timer = null;
	}
}
